/*
 * Decompiled with CFR 0.152.
 */
package levelup2;

import java.util.List;
import levelup2.api.IProcessor;
import levelup2.capability.PlayerCapability;
import levelup2.config.LevelUpConfig;
import levelup2.event.CapabilityEventHandler;
import levelup2.network.SkillPacketHandler;
import levelup2.player.IPlayerClass;
import levelup2.player.PlayerExtension;
import levelup2.proxy.CommonProxy;
import levelup2.skills.SkillRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="levelup2", name="Level Up! Reloaded", version="${version}", acceptedMinecraftVersions="[1.12]")
public class LevelUp2 {
    public static final String ID = "levelup2";
    @Mod.Instance(value="levelup2")
    public static LevelUp2 INSTANCE;
    @SidedProxy(clientSide="levelup2.proxy.ClientProxy", serverSide="levelup2.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        LevelUpConfig.init(evt.getSuggestedConfigurationFile());
        CapabilityManager.INSTANCE.register(IPlayerClass.class, new PlayerCapability.CapabilityPlayerClass(), PlayerExtension.class);
        CapabilityManager.INSTANCE.register(IProcessor.class, new PlayerCapability.CapabilityProcessorClass(), PlayerCapability.CapabilityProcessorDefault.class);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityEventHandler());
        proxy.registerItemMeshes();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxy.registerGui();
        SkillPacketHandler.init();
        SkillRegistry.loadSkills();
        proxy.registerColors();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        LevelUpConfig.getBlacklistOutputs();
        SkillRegistry.postLoadSkills();
        LevelUpConfig.registerSkillProperties();
        SkillRegistry.registerRecipes();
    }

    @Mod.EventBusSubscriber(modid="levelup2")
    public static class RegistryEventHandler {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> evt) {
            IForgeRegistry reg = evt.getRegistry();
            RegistryEventHandler.registerItem((IForgeRegistry<Item>)reg, SkillRegistry.surfaceOreChunk);
            RegistryEventHandler.registerItem((IForgeRegistry<Item>)reg, SkillRegistry.netherOreChunk);
            RegistryEventHandler.registerItem((IForgeRegistry<Item>)reg, SkillRegistry.endOreChunk);
            RegistryEventHandler.registerItem((IForgeRegistry<Item>)reg, SkillRegistry.respecBook);
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> evt) {
            IForgeRegistry reg = evt.getRegistry();
            reg.register(new ShapelessOreRecipe(new ResourceLocation(LevelUp2.ID, "reclaim"), new ItemStack(Blocks.field_150351_n, 4), new Object[]{Items.field_151145_ak, Items.field_151145_ak, Items.field_151145_ak, Items.field_151145_ak}).setRegistryName(new ResourceLocation(LevelUp2.ID, "gravel")));
            RegistryEventHandler.oreLoad((IForgeRegistry<IRecipe>)reg);
            SkillRegistry.initPlankCache();
        }

        public static void oreLoad(IForgeRegistry<IRecipe> reg) {
            if (!SkillRegistry.isNullList(LevelUpConfig.oreList)) {
                RegistryEventHandler.registerOreRecipes(reg, LevelUpConfig.oreList, SkillRegistry.surfaceOreChunk);
            }
            if (!SkillRegistry.isNullList(LevelUpConfig.netherOreList)) {
                RegistryEventHandler.registerOreRecipes(reg, LevelUpConfig.netherOreList, SkillRegistry.netherOreChunk);
            }
            if (!SkillRegistry.isNullList(LevelUpConfig.endOreList)) {
                RegistryEventHandler.registerOreRecipes(reg, LevelUpConfig.endOreList, SkillRegistry.endOreChunk);
            }
        }

        public static void registerItem(IForgeRegistry<Item> reg, Item item) {
            reg.register((IForgeRegistryEntry)item);
        }

        public static void registerOreRecipes(IForgeRegistry<IRecipe> reg, List<String> ores, Item item) {
            for (int i = 0; i < ores.size(); ++i) {
                String names = ores.get(i);
                if (!OreDictionary.doesOreNameExist((String)names)) continue;
                ItemStack ore = SkillRegistry.getOreEntry(names);
                ItemStack chunk = new ItemStack(item, 1, i);
                if (!ore.func_190926_b()) {
                    reg.register(new ShapelessOreRecipe(new ResourceLocation(LevelUp2.ID, "orechunk"), ore.func_77946_l(), new Object[]{chunk, chunk}).setRegistryName(LevelUp2.ID, names.toLowerCase()));
                }
                OreDictionary.registerOre((String)names, (ItemStack)chunk);
            }
        }
    }
}

